<?php
namespace EdgeCore\CPT\Shortcodes\IntroSection;

use EdgeCore\Lib;

class IntroSection implements Lib\ShortcodeInterface {
	private $base;
	
	public function __construct() {
		$this->base = 'edgtf_intro_section';

		add_action('vc_before_init', array($this, 'vcMap'));
	}

	/**
	 * Returns base for shortcode
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}

	/**
	 * Maps shortcode to Visual Composer. Hooked on vc_before_init
	 */
	public function vcMap() {
		if(function_exists('vc_map')) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Edge Intro Section', 'edgtf-core' ),
					'base'                      => $this->getBase(),
					'category'                  => esc_html__( 'by EDGE', 'edgtf-core' ),
					'icon'                      => 'icon-wpb-intro-section extended-custom-icon',
                    'allowed_container_element' => 'vc_row',
					'params'                    => array(
						array(
							'type'        => 'textfield',
							'param_name'  => 'headline',
							'heading'     => esc_html__( 'Headline', 'edgtf-core' ),
							'admin_label' => true,
							'group'		  => esc_html__( 'First Screen', 'edgtf-core' )
						),
						array(
						    'type'        => 'attach_image',
						    'param_name'  => 'additional_image',
						    'heading'     => esc_html__( 'Additional Image', 'edgtf-core' ),
							'group'		  => esc_html__( 'First Screen', 'edgtf-core' )
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'title',
							'heading'     => esc_html__( 'Title', 'edgtf-core' ),
							'admin_label' => true,
							'group'		  => esc_html__( 'Second Screen', 'edgtf-core' )
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'description',
							'heading'     => esc_html__( 'Description', 'edgtf-core' ),
							'group'		  => esc_html__( 'Second Screen', 'edgtf-core' )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'link',
							'heading'    => esc_html__( 'Link', 'edgtf-core' ),
							'group'		  => esc_html__( 'Second Screen', 'edgtf-core' )
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'link_text',
							'heading'     => esc_html__( 'Link Text', 'edgtf-core' ),
							'dependency' => array( 'element' => 'link', 'not_empty' => true ),
							'group'		  => esc_html__( 'Second Screen', 'edgtf-core' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'target',
							'heading'     => esc_html__( 'Link Target', 'edgtf-core' ),
							'value'       => array_flip( haar_edge_get_link_target_array(false, true) ),
							'dependency' => array( 'element' => 'link', 'not_empty' => true ),
							'group'		  => esc_html__( 'Second Screen', 'edgtf-core' )
						)
                    )
				)
			);
		}
	}

	/**
	 * Renders shortcodes HTML
	 *
	 * @param $atts array of shortcode params
	 * @param $content string shortcode content
	 * @return string
	 */
	public function render($atts, $content = null) {
		$args = array(
            'headline'             	=> '',
            'additional_image'      => '',
            'title'             	=> '',
            'description'	    	=> '',
            'link'          		=> '',
            'link_text'          	=> '',
            'link_target'      		=> '',
            'target'				=> ''
		);
		
		$params = shortcode_atts($args, $atts);
		$params['holder_classes'] = $this->getHolderClasses($params);
		$params['button_parameters']    = $this->getButtonParameters( $params );
        $params['content'] = $content;

		$html = edgtf_core_get_shortcode_module_template_part('templates/intro-section-template', 'intro-section', '', $params);
		
		return $html;
	}


	/**
	 * Generates holder classes
	 *
	 * @param $params
	 *
	 * @return string
	 */
	private function getHolderClasses($params){
		$holderClasses = array();

		if (!empty($params['additional_image'])) {
			$holderClasses[] = 'edgtf-with-additional-image';
		}

		return implode(' ', $holderClasses);
	}

	private function getButtonParameters( $params ) {
		$button_params_array = array();
		
		if ( ! empty( $params['link_text'] ) ) {
			$button_params_array['text'] = $params['link_text'];
		}
		
		if ( ! empty( $params['link'] ) ) {
			$button_params_array['link'] = $params['link'];
		}
		
		$button_params_array['target'] = ! empty( $params['link_target'] ) ? $params['link_target'] : '_self';
		
		$button_params_array['color'] = '#fff';
		$button_params_array['hover_color'] = '#fff';
		$button_params_array['background_color'] = '#f04c4b';
		$button_params_array['hover_background_color'] = 'transparent';
		$button_params_array['border_color'] = '#f04c4b';
		$button_params_array['hover_border_color'] = '#fff';
		$button_params_array['target'] = '_blank';

		return $button_params_array;
	}
}